/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.logging;

import de.willuhn.logging.Level;
import de.willuhn.logging.Message;
import de.willuhn.logging.targets.Target;
import de.willuhn.util.History;
import de.willuhn.util.Queue;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;

public class Logger {
    private static final int BUFFER_SIZE = 200;
    private static ArrayList targets = new ArrayList();
    private static History lastLines = new History(200);
    private static Level level = Level.DEFAULT;
    private static LoggerThread lt = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTarget(Target target) {
        if (target == null) {
            return;
        }
        ArrayList arrayList = targets;
        synchronized (arrayList) {
            targets.add(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTarget(Target target) {
        if (target == null) {
            return;
        }
        ArrayList arrayList = targets;
        synchronized (arrayList) {
            targets.remove(target);
        }
    }

    public static void setLevel(Level level) {
        if (level == null) {
            return;
        }
        Logger.level = level;
    }

    public static Level getLevel() {
        return level;
    }

    public static boolean isLogging(Level l) {
        return l != null && l.getValue() >= level.getValue();
    }

    public static void trace(String message) {
        Logger.write(Level.TRACE, message);
    }

    public static void debug(String message) {
        Logger.write(Level.DEBUG, message);
    }

    public static void info(String message) {
        Logger.write(Level.INFO, message);
    }

    public static void warn(String message) {
        Logger.write(Level.WARN, message);
    }

    public static void error(String message) {
        Logger.write(Level.ERROR, message);
    }

    public static void error(String message, Throwable t) {
        Logger.write(Level.ERROR, message, t);
    }

    public static void flush() throws InterruptedException {
        while (lt.messages.size() > 0) {
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Logger.lt.shutdown();
        try {
            while (!Logger.lt.finished()) {
                Thread.sleep(50L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            lt.interrupt();
        }
        ArrayList arrayList = targets;
        synchronized (arrayList) {
            Target target = null;
            for (int i = 0; i < targets.size(); ++i) {
                target = (Target)targets.get(i);
                try {
                    target.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            targets = new ArrayList();
        }
    }

    public static Message[] getLastLines() {
        return (Message[])lastLines.toArray(new Message[lastLines.size()]);
    }

    public static void write(Level level, String message) {
        Logger.write(level, message, null);
    }

    public static void write(Level level, String message, Throwable t) {
        Logger.write(level, null, null, null, message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Level level, String host, String clazz, String method, String message, Throwable t) {
        StackTraceElement[] stack;
        if (level.getValue() < Logger.level.getValue()) {
            return;
        }
        if (t != null) {
            ByteArrayOutputStream bos = null;
            try {
                bos = new ByteArrayOutputStream();
                t.printStackTrace(new PrintStream(bos));
                message = message + "\n" + bos.toString();
            }
            finally {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
        }
        if ((clazz == null || method == null) && (stack = new Throwable().getStackTrace()) != null) {
            for (int i = 0; i < stack.length; ++i) {
                clazz = stack[i].getClassName();
                method = stack[i].getMethodName();
                if (!Logger.class.getName().equals(clazz)) break;
            }
        }
        Logger.write(new Message(new Date(), level, host, clazz, method, message, Thread.currentThread().getName()));
    }

    public static void write(Message message) {
        lastLines.push(message);
        Logger.lt.write(message);
    }

    static {
        lt = new LoggerThread("Logger-Thread");
        lt.start();
    }

    private static class LoggerThread
    extends Thread {
        private Queue messages = new Queue(Queue.CAPACITY_MAX / 2);
        private boolean quit = false;
        private boolean finished = false;

        public LoggerThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        private void write(Message msg) {
            if (this.quit) {
                return;
            }
            int retryCount = 1000;
            int count = 0;
            while (true) {
                if (count++ >= retryCount) {
                    this.println("***** [WARN] Logger queue full, writing to STDOUT *****");
                    this.println(msg.toString());
                    return;
                }
                try {
                    this.messages.push(msg);
                    return;
                }
                catch (Queue.QueueFullException queueFullException) {
                    continue;
                }
                break;
            }
        }

        private void shutdown() {
            this.quit = true;
        }

        private boolean finished() {
            return this.finished;
        }

        private void println(String text) {
            try {
                System.out.println(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Message msg = null;
            while (true) {
                if (this.messages.size() == 0 && this.quit) {
                    this.finished = true;
                    return;
                }
                if (this.messages.size() == 0) {
                    try {
                        LoggerThread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                msg = (Message)this.messages.pop();
                Target target = null;
                ArrayList arrayList = targets;
                synchronized (arrayList) {
                    if (targets.size() == 0) {
                        this.println(msg.toString());
                        continue;
                    }
                    for (int i = 0; i < targets.size(); ++i) {
                        target = (Target)targets.get(i);
                        try {
                            target.write(msg);
                            continue;
                        }
                        catch (Exception e) {
                            this.println("alert: error while logging the following message: " + msg.toString());
                        }
                    }
                }
            }
        }
    }
}

